//
//  MenuViewController.swift
//  Demo iOS
//
//  Created by Benoit Vasseur on 05/07/2022.
//

import UIKit

class MenuViewController: BaseViewController, UITableViewDelegate, UITableViewDataSource {
    
    @IBOutlet weak var tableview: UITableView!
    
    fileprivate var menu: [(title: String, segue: String)] = [
        ("Synchronize", "pushToSynchronize"),
        ("ChangePassword", "pushToChangePassword"),
        ("Unlock Device", "pushToUnlockDevice"),
        ("Get online OTP", "pushToOnlineOTP"),
        ("Get offline OTP", "pushToOfflineOTP"),
        ("Get biometric online OTP", "pushToBioOnlineOTP"),
        ("Register Biometric", "pushToRegisterBiometric"),
        ("Get online Seal", "pushToOnlineSeal"),
        ("Get offline Seal", "pushToOfflineSeal"),
        ("Check pending push", "pushToPendingPush")
    ]
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "Menu"
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        if InweboService.sharedInstance.isBlocked() {
            self.performSegue(withIdentifier: "pushToUnlockDevice", sender: self)
        }
        NotificationCenter.default.addObserver(self, selector: #selector(notificationReceived(notification:)), name: Notification.Name("notification"), object: nil)
        if let pendingPush = AppDelegate.shared()?.pendingPush, pendingPush {
            notificationReceived(notification: nil)
        }
    }
    
    // MARK: Notifications
    @objc
    func notificationReceived(notification: Notification?) {
        self.performSegue(withIdentifier: "pushToPendingPush", sender: nil)
    }
    
    // MARK: Tableview
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return self.menu.count
    }
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let identifier = "cellIdentifier"
        var cell = tableView.dequeueReusableCell(withIdentifier: identifier)
        if (cell == nil) {
            cell = UITableViewCell(style: .default, reuseIdentifier: identifier)
        }
        cell!.textLabel?.text = self.menu[indexPath.row].title
        
        return cell!
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        self.performSegue(withIdentifier: self.menu[indexPath.row].segue, sender: self)
    }


    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if let destination = segue.destination as? CheckPendingPushViewController, sender == nil {
            destination.checkImmediately = true
        }
    }

}
